package gov.va.med.mhv.phr.allergy.model;

import org.displaytag.decorator.TableDecorator;

/**
 * Defines the order in which allergy SEI views are ordered.
 * @author                   
 */
public class AllergySEIRowSorter extends MultiPropertyRowSorter {

    private static final SortOrder[] SORT_ORDER = {
        new SortOrder("SEIDate", false),
        new SortOrder("SEIAllergyRecord", true),
        new SortOrder("SEISeverity", true),
        new SortOrder("SEISource", true)
    };

    public AllergySEIRowSorter(String propertyName, TableDecorator tableDecorator,
        boolean isAscending)
    {
        super(propertyName, tableDecorator, isAscending);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.model.MultiplePropertySorter#getSortOrder()
     */
    @Override
    protected SortOrder[] getSortOrder()
    {
        return SORT_ORDER;
    }

}
